unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Labdau;
type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
  end;

var
  Form1: TForm1;
  Labda:TLabda;

implementation

{$R *.DFM}


procedure TForm1.FormCreate(Sender: TObject);
begin
  Labda:=TLabda.Create(Form1,clRed);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Labda.Free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var segedpos:TPoint;
begin
  // az idzt mozgatja a labdt
  // tkzskor irnyvlts a hatrokon
   if (Labda.Pos.x+Labda.meret+Labda.dx>form1.clientwidth) or
      (Labda.Pos.x+Labda.dx<0) then Labda.dx:=-Labda.dx;
   if (Labda.Pos.y+Labda.meret+Labda.dy>form1.clientheight) or
      (Labda.Pos.y+Labda.dy<0) then  Labda.dy:=-Labda.dy;
   segedpos.x:=Labda.Pos.x+Labda.dx;
   segedpos.y:=Labda.Pos.y+Labda.dy;
   Labda.Pos:=segedpos;
end;

procedure TForm1.FormResize(Sender: TObject);
var segedpos:TPoint;
begin
  // tmretezskor a labda kzpre kerl
  segedpos.x:=(form1.clientwidth-Labda.meret) div 2;
  segedpos.y:=(form1.clientheight-Labda.meret) div 2;
  Labda.Pos:=segedpos;
  Refresh;
end;

procedure TForm1.FormPaint(Sender: TObject);
var kiir:string;
begin
     // a kperny kzepre szveget runk
     Canvas.Brush.Color:=Form1.Color;
     Canvas.Font.Color:=clDkGray;
     Canvas.Font.Size:=20;
     Canvas.Font.Style:=[fsBold];
     Canvas.Copymode:=cmSrcCopy;
     kiir:='Pattog pttys labda';
     Canvas.TextOut((ClientWidth-Canvas.TextWidth(kiir)) div 2,
                    (ClientHeight-Canvas.TextHeight(kiir)) div 2,kiir);
     // s alappozciba helyezzk a labdt
     Labda.Kirajz;
end;

end.
